
Program MakeDB;

const
  COPYRIGHT  = 'MakeDB v1.1                      Copyright (C) 1996, Xavier Defrang, Chromo Zone';
  LINE       = '';
  CONTACT    = 'To contact Chromo Zone, e-mail : 106146.1452@compuserve.com';
  LINE2      = ';------------------------------------------------------------------------------';

{---------------------------------------------------------------------------}

procedure Error( ErrorStr : String );
begin
  WriteLn('ERROR : ', ErrorStr );
  Halt( $00 );
end;

{---------------------------------------------------------------------------}

procedure UpCaseString( PASCII : Pointer ); assembler;
asm
                push    ds
                lds     si, PASCII
                mov     ax, ds
                mov     es, ax
                xor     cx, cx
                mov     cl, byte ptr [si]
                mov     ah, 32
                inc     si
                mov     di, si
@NextChar:      lodsb
                cmp     al, 'a'
                jb      @SkipChar
                cmp     al, 'z'
                jg      @SkipChar
                sub     al, ah
                mov     es:[di], al
@SkipChar:      inc     di
                dec     cx
                jnz     @NextChar
                pop     ds
end;

{---------------------------------------------------------------------------}

function hex( X : Byte ) : String;
const
  HEX_CHARS : array[0..$F] of char = '0123456789ABCDEF';
begin
  Hex[0] := Chr( $04 );
  Hex[1] := '0';
  Hex[2] := HEX_CHARS[ ( X SHR $04 ) ];
  Hex[3] := HEX_CHARS[ ( X AND $0F ) ];
  Hex[4] := 'h';
end;

{---------------------------------------------------------------------------}

procedure Help;
begin
  WriteLn('This program allows you to read the informations stored into an EXE file header.' );
  WriteLn('Syntax : MAKEDB.EXE source.ext [target.ext]'#10#13);
  WriteLn( CONTACT );
  Halt( $00 );
end;

{---------------------------------------------------------------------------}

function FileExists( InFile : String ) : boolean;
var
  FileHandle : File;
begin
  {$I-}
  Assign( FileHandle, Infile );
  Reset( FileHandle, 1 );
  Close( FileHandle );
  {$I+}
  FileExists := ( IOResult = 0 );
end;

{---------------------------------------------------------------------------}

var
  SourceName    : String;
  TargetName    : String;
  SourceFile    : File;
  TargetFile    : Text;
  SourceSize    : LongInt;
  TargetSize    : LongInt;
  Buffer        : Array[1..$10] of Byte;
  BytesRead     : Word;
  BytesCount    : LongInt;
  Dummy         : Word;
  Divider       : Word;
begin
  Write( LINE );
  Write( COPYRIGHT );
  Write( LINE );
  if ( ParamCount = 0 ) then Help;
  SourceName := ParamStr( 1 );
  UpCaseString( @SourceName );
  TargetName := ParamStr( 2 );
  if ( Ord( TargetName[0] ) <> 0 ) then UpCaseString( @TargetName )
  else
  begin
    Dummy := Pos( '.', SourceName ) - 1;
    if ( Dummy = 0 ) then Dummy := Ord( SourceName[0] );
    TargetName := Copy( SourceName, 1, Dummy );
    TargetName := TargetName + '.DB';
  end;
  if ( NOT ( FileExists( SourceName ) ) ) then Error( 'Cannot find or open ' + SourceName );
  Assign( SourceFile, SourceName );
  Reset( SourceFile, 1 );
  SourceSize := FileSize( SourceFile );
  Assign( TargetFile, TargetName );
  ReWrite( TargetFile );
  WriteLn( 'Source: ' + SourceName + ', ', SourceSize, ' bytes.' );
  WriteLn( 'Target: ' + TargetName );
  BytesCount := 0;
  WriteLn( TargetFile );
  WriteLn( TargetFile, LINE2 );
  WriteLn( TargetFile, '; This file has been written by MakeDB v1.1, (C) 1996, X. Defrang, Chromo Zone' );
  WriteLn( TargetFile, LINE2 );
  WriteLn( TargetFile, '; ' + CONTACT );
  WriteLn( TargetFile, LINE2 );
  WriteLn( TargetFile );
  WriteLn( TargetFile, '; Source file : ' + SourceName + ', ', SourceSize, ' bytes' );
  Writeln( TargetFile );
  Divider := SourceSize DIV 70;
  Repeat
    BlockRead( SourceFile, Buffer, $08, BytesRead );
    Write( TargetFile, #09 + 'db   ' );
    For Dummy := 1 to BytesRead do
    begin
      Write( TargetFile, hex( Buffer[Dummy] ) );
      if ( Dummy < BytesRead ) then Write( TargetFile, ',' );
    end;
    WriteLn( TargetFile );
    Inc( BytesCount, BytesRead );
    if ( BytesCount MOD Divider = 0 ) then Write( '>' );
  Until ( BytesCount = SourceSize );
  WriteLn( TargetFile );
  Close( TargetFile );
  WriteLn( ' Done!' );
  Close( SourceFile );
  WriteLn( CONTACT );
end.